/*
 * Decompiled with CFR 0.152.
 */
package org.jwaresoftware.mcmods.armorunder.runtime;

import net.minecraft.client.Minecraft;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IThreadListener;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.jwaresoftware.mcmods.armorunder.ModItem;
import org.jwaresoftware.mcmods.armorunder.ModItems;
import org.jwaresoftware.mcmods.armorunder.runtime.CustomLinedArmorTooltip;
import org.jwaresoftware.mcmods.armorunder.runtime.LinedArmorTooltip;
import org.jwaresoftware.mcmods.armorunder.runtime.ModInventoryModelInit;
import org.jwaresoftware.mcmods.armorunder.runtime.ModRuntimeSkeleton;
import org.jwaresoftware.mcmods.lib.api.mod.IModInventoryRenderingHelper;

public class ModRuntimeSP
extends ModRuntimeSkeleton {
    private final Minecraft MINECRAFT = Minecraft.func_71410_x();
    private IModInventoryRenderingHelper _inventoryModelRegistrar = new ModInventoryModelInit();

    @Override
    protected String getId() {
        return "SP";
    }

    @Override
    public boolean hasUI() {
        return true;
    }

    public EntityPlayer getClientPlayer() {
        return this.MINECRAFT.field_71439_g;
    }

    public World getClientWorld() {
        return this.MINECRAFT.field_71441_e;
    }

    public IThreadListener getThreadListener(MessageContext context) {
        return context.side.isClient() ? this.MINECRAFT : context.getServerHandler().field_147369_b.field_71133_b;
    }

    public EntityPlayer getPlayer(MessageContext context) {
        return context.side.isClient() ? this.MINECRAFT.field_71439_g : context.getServerHandler().field_147369_b;
    }

    @Override
    protected IModInventoryRenderingHelper getRenderingHelper() {
        return this._inventoryModelRegistrar;
    }

    @Override
    protected void makeModItems() {
        boolean reset_tab = this.getConfig().useModTab();
        if (reset_tab) {
            this.setupModTab();
        }
        super.makeModItems();
        if (reset_tab) {
            this.resetItemsTab();
        }
    }

    private void setupModTab() {
        ModItem tabIcon = ModItems.icon;
        CreativeTabs tab = new CreativeTabs("armorunder", (Item)tabIcon){
            final /* synthetic */ Item val$tabIcon;
            {
                this.val$tabIcon = item;
                super(x0);
            }

            @SideOnly(value=Side.CLIENT)
            public ItemStack func_78016_d() {
                return new ItemStack(this.val$tabIcon);
            }
        };
        this.getConfig().setTab(tab);
    }

    @Override
    protected void installModHandlers() {
        super.installModHandlers();
        MinecraftForge.EVENT_BUS.register((Object)new LinedArmorTooltip());
        if (this.getConfig().includeSpecialLiners()) {
            MinecraftForge.EVENT_BUS.register((Object)new CustomLinedArmorTooltip());
        }
    }

    @Override
    protected void registerRenderModels() {
        ModItems.instances.forEach(item -> this.doRenderSetupOrFail(item.oid(), (Item)item));
    }

    private void resetItemsTab() {
        CreativeTabs tab = this.getOwnedTab();
        ModItems.instances.forEach(item -> item.func_77637_a(tab));
    }
}

